<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Mainmodel extends CI_Model
{
	
	
	public function login($username, $password)
	{
		//echo $password;exit;
		$this->db->select('*');
		$this->db->from('admin');
		$this->db->where('username', $username);
		$this->db->where('password', md5($password));		
		$query = $this->db->get();	
		// echo $this->db->last_query();exit;
		if ($query !== FALSE)
		{	
			if($query->num_rows() > 0){
				return $query->row();
			}else{
				return false;
			}
		}
		else
		{
			return false;
		}
    }
    
    	public function common_fetch($table,$where)
	{
		$this->db->select()->from($table);
		$this->db->where($where);
		$this->db->order_by("id","desc");
		$qry=$this->db->get();
		return $qry->result();
	}
	function common_insert($table,$data)
	{
	    $this->db->insert($table,$data);
	    return $this->db->insert_id();
	}
	function common_update($table,$data,$where)
	{
	    $this->db->where($where);
	    $this->db->update($table,$data);
	    return true;
	}
	function common_delete($table,$where)
	{
	    $this->db->where($where);
	    $this->db->delete($table);
	}
	
	public function get_all_details_school($pdata, $getcount=null)
    {
//         $your_date = strtotime("1 day", strtotime(date('Y-m-d')));
// $new_date = date("Y-m-d", $your_date);


        $search_1 = array
        (
            1 => 'coupon_code'
        );        
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
           // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'], $pdata['search_at_1'] ); 
          // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'] ); 
         // $this->db->where('bookings.booking_id', $pdata['search_text_1'] ); 
          
        }
         if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
         {
           //  $this->db->where('bookings.booking_date', $pdata['search_on_1'] ); 
         }
          if(isset($pdata['search_at_1'])!="" && !empty($pdata['search_at_1']))
          {
             // $this->db->where('bookings.customer_mobile', $pdata['search_at_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
      // $this->db->where('schools.status', 'cancel' ); 
        if($getcount)
        {
             $this->db->select('schools.id');
            $this->db->from('schools');
            $this->db->join('school_logins','school_logins.school_id = schools.id','left');
            $this->db->order_by('schools.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('schools.*,DATE_FORMAT(schools.created_on,"%d-%m-%Y") as created_on,
            school_logins.username,school_logins.status as user_status
            ');
            $this->db->from('schools');
            $this->db->join('school_logins','school_logins.school_id = schools.id','left');
            $this->db->order_by('schools.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_classes_data($school_id)
    {
        $this->db->select('class.*,school_sessions.from_year,school_sessions.to_year,count(students.id) as total_students,
        GROUP_CONCAT(staff.employee_name SEPARATOR ", ") AS class_teachers ');
        $this->db->from('class');
        $this->db->join('school_sessions','school_sessions.id  = class.session_id','left');
        $this->db->join('students','students.class_id = class.id','left');
        $this->db->join('staff','staff.employee_class = class.id','left');
        $this->db->where('class.delete_status',1);
        $this->db->group_by('class.id');
        $this->db->order_by('class.class_name', 'desc');
        $qry = $this->db->get();
        return $qry->result();
    }
    public function get_search_all_classes_data($school_id,$session_id,$class_id,$deactivate)
    {
        $this->db->select('class.*,school_sessions.from_year,school_sessions.to_year,count(students.id) as total_students,
        GROUP_CONCAT(staff.employee_name SEPARATOR ", ") AS class_teachers ');
        $this->db->from('class');
        $this->db->join('school_sessions','school_sessions.id  = class.session_id','left');
        $this->db->join('students','students.class_id = class.id','left');
        $this->db->join('staff','staff.employee_class = class.id','left');
        $this->db->where('class.delete_status',1);
        if(!empty($school_id)){
             $this->db->where('class.school_id',$school_id);
        }
        if(!empty($school_id)){
             $this->db->where('class.session_id',$session_id);
         }
         if(!empty($class_id)){
             $this->db->where('class.id',$class_id);
         }
         if(!empty($deactivate)){
             $this->db->where('class.status',0);
         }
        
        
        $this->db->group_by('class.id');
        $this->db->order_by('class.class_name', 'desc');
        $qry = $this->db->get();
      //  echo $this->db->last_query();exit;
        return $qry->result();
    }
    public function get_all_transfer_class_details($from_session_id,$from_class_id,$school_id)
    {
        $this->db->select('students.*');
        $this->db->from('students');
        $this->db->where('students.session_id', $from_session_id);
        $this->db->where('students.class_id', $from_class_id);
        $this->db->where('students.school_id', $school_id);
        $this->db->order_by('students.admission_id','asc');
        $qry = $this->db->get();
        return $qry->result();
    }
    
    public function get_all_students_breakup_details()
    {
        $this->db->select('class.class_name,count(students.id) as total_students,
        SUM(CASE WHEN students.student_gender = "female" THEN 1 ELSE 0 END) as total_girls,
        SUM(CASE WHEN students.student_gender = "male" THEN 1 ELSE 0 END) as total_boys
        ');
        $this->db->from('class');
        $this->db->join('students','students.class_id = class.id','left');
        $this->db->where('class.school_id', $this->session->userdata('school_id'));
        $this->db->group_by('class.id');
        $this->db->order_by('class.id','desc');
        $qry = $this->db->get();
        return $qry->result();
    }
    
    
    public function get_all_students_details($pdata, $getcount=null)
    {
              
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
            $this->db->group_start();
           // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'], $pdata['search_at_1'] ); 
          // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'] ); 
          $this->db->where('students.admission_id', $pdata['search_text_1'] ); 
          $this->db->or_where('students.student_name', $pdata['search_text_1'] ); 
          $this->db->or_where('students.father_name', $pdata['search_text_1'] ); 
          $this->db->or_where('students.father_mobile', $pdata['search_text_1'] ); 
          $this->db->group_end();
          
        }
         if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
         {
             $this->db->where('students.session_id', $pdata['search_on_1'] ); 
         }
          if(isset($pdata['search_at_1'])!="" && !empty($pdata['search_at_1']))
          {
              $this->db->where('students.class_id', $pdata['search_at_1'] ); 
          }
          if(isset($pdata['search_is_1'])!="" && !empty($pdata['search_is_1']))
          {
              $this->db->where('students.status', $pdata['search_is_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('students.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('students.id');
            $this->db->from('students');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('students.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('students.*,DATE_FORMAT(students.created_on,"%d-%m-%Y") as created_on,
            class.class_name
            ');
            $this->db->from('students');
            $this->db->join('class','class.id = students.class_id','left');
            $this->db->order_by('students.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
        //echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_all_inquiry_details($pdata, $getcount=null)
     {
              
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
            //$this->db->group_start();
          $this->db->where('student_inquiry.inquiry_date >=', $pdata['from_date'] ); 
         // $this->db->group_end();
          
        }
         if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
         {
             $this->db->where('student_inquiry.inquiry_date <=', $pdata['to_date'] ); 
         }
          if(isset($pdata['child_name'])!="" && !empty($pdata['child_name']))
          {
              $this->db->where('student_inquiry.child_name', $pdata['child_name'] ); 
          }
          if(isset($pdata['inquiry_status'])!="" && !empty($pdata['inquiry_status']))
          {
              $this->db->where('student_inquiry.inquiry_status', $pdata['inquiry_status'] ); 
          }
          if(isset($pdata['from_next_followup_date'])!="" && !empty($pdata['from_next_followup_date']))
          {
              $this->db->where('student_inquiry.next_followup_date >=', $pdata['from_next_followup_date'] ); 
          }
          if(isset($pdata['to_next_followup_date'])!="" && !empty($pdata['to_next_followup_date']))
          {
              $this->db->where('student_inquiry.next_followup_date <=', $pdata['to_next_followup_date'] ); 
          }
          if(isset($pdata['session_id'])!="" && !empty($pdata['session_id']))
          {
              $this->db->where('student_inquiry.session_id', $pdata['session_id'] ); 
          }
          if(isset($pdata['class_id'])!="" && !empty($pdata['class_id']))
          {
              $this->db->where('student_inquiry.class_id', $pdata['class_id'] ); 
          }
          if(isset($pdata['father_mobile'])!="" && !empty($pdata['father_mobile']))
          {
              $this->db->where('student_inquiry.father_mobile', $pdata['father_mobile'] ); 
          }
          if(isset($pdata['file_no'])!="" && !empty($pdata['file_no']))
          {
              $this->db->where('student_inquiry.file_no', $pdata['file_no'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('student_inquiry.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('student_inquiry.id');
            $this->db->from('student_inquiry');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('student_inquiry.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('student_inquiry.*,DATE_FORMAT(student_inquiry.created_on,"%d-%m-%Y") as created_on,
             DATE_FORMAT(student_inquiry.next_followup_date,"%d-%m-%Y") as next_followup_date,class.class_name
            
            ');
            $this->db->from('student_inquiry');
            $this->db->join('class','class.id = student_inquiry.class_id','left');
            $this->db->order_by('student_inquiry.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_all_registration_details($pdata, $getcount=null)
    {
        //  echo "<pre>";
        //  print_r($pdata);exit;
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
            //$this->db->group_start();
          $this->db->where('student_registration.registration_date >=', $pdata['from_date'] ); 
         // $this->db->group_end();
        }
         if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
         {
             $this->db->where('student_registration.registration_date <=', $pdata['to_date'] ); 
         }
          if(isset($pdata['name'])!="" && !empty($pdata['name']))
          {
              $this->db->where('student_registration.child_name', $pdata['name'] ); 
          }
          if(isset($pdata['registration_status'])!="" && !empty($pdata['registration_status']))
          {
              $this->db->where('student_registration.registration_status', $pdata['registration_status'] ); 
          }
          if(isset($pdata['session_id'])!="" && !empty($pdata['session_id']))
          {
              $this->db->where('student_registration.session_id', $pdata['session_id'] ); 
          }
          if(isset($pdata['class_id'])!="" && !empty($pdata['class_id']))
          {
              $this->db->where('student_registration.class_id', $pdata['class_id'] ); 
          }
          if(isset($pdata['mobile'])!="" && !empty($pdata['mobile']))
          {
              $this->db->where('student_registration.father_mobile', $pdata['mobile'] ); 
          }
          if(isset($pdata['form_id'])!="" && !empty($pdata['form_id']))
          {
              $this->db->where('student_registration.file_no', $pdata['form_id'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('student_registration.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('student_registration.id');
            $this->db->from('student_registration');
            $this->db->join('class','class.id = student_registration.class_id','left');
            $this->db->order_by('student_registration.id','desc'); 
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('student_registration.*,DATE_FORMAT(student_registration.created_on,"%d-%m-%Y") as created_on,
             DATE_FORMAT(student_registration.registration_date,"%d-%m-%Y") as registration_date,class.class_name
            
            ');
            $this->db->from('student_registration');
            $this->db->join('class','class.id = student_registration.class_id','left');
           // $this->db->join('school_logins','school_logins.school_id = schools.id','left');
            $this->db->order_by('student_registration.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_all_staff_details($pdata, $getcount=null)
    {
       // echo $this->input->post('search_on_1');exit;      
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
           // $this->db->group_start();
           // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'], $pdata['search_at_1'] ); 
          // $this->db->like($search_1[$pdata['search_on_1']], $pdata['search_text_1'] ); 
          $this->db->where('staff.employee_name', $pdata['search_text_1'] ); 
         
         // $this->db->group_end();
          
        }
        //  if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
        //  {
        //      $this->db->where('students.session_id', $pdata['search_on_1'] ); 
        //  }
        //   if(isset($pdata['search_at_1'])!="" && !empty($pdata['search_at_1']))
        //   {
        //       $this->db->where('students.class_id', $pdata['search_at_1'] ); 
        //   }
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('staff.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('staff.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('staff.id');
            $this->db->from('staff');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('staff.id','desc');
            $query = $this->db->get();
           // echo $this->db_last_query();exit;
            return $query->num_rows();
        }
        else
        {
            $this->db->select('staff.*,DATE_FORMAT(staff.created_on,"%d-%m-%Y") as created_on,
            GROUP_CONCAT(class.class_name) as class_name
            
            ');
            $this->db->from('staff');
            $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('staff.id','desc');
            $this->db->group_by('staff.id');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
        //echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_daycare_data($school_id)
    {
        $this->db->select('activities.*,DATE_FORMAT(activities.start_time,"%h:%i %p") as start_time,
        DATE_FORMAT(activities.end_time,"%h-%i %p") as end_time ');
        // GROUP_CONCAT(staff.employee_name SEPARATOR ", ") AS class_teachers
        $this->db->from('activities');
        // $this->db->join('school_sessions','school_sessions.id  = class.session_id','left');
        // $this->db->join('students','students.class_id = class.id','left');
        // $this->db->join('staff','staff.employee_class = class.id','left');
        $this->db->where('activities.delete_status',1);
        $this->db->where('activities.school_id',$school_id);
       // $this->db->where('activities.date',date('Y-m-d'));
      //  $this->db->group_by('activities.id');
        $this->db->order_by('activities.id', 'desc');
        $qry = $this->db->get();
        return $qry->result();
    }
    
    public function get_all_inventory_variant_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('staff.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('staff.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('inventory_varients.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('inventory_varients.id');
            $this->db->from('inventory_varients');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('inventory_varients.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('inventory_varients.*,DATE_FORMAT(inventory_varients.created_on,"%d-%m-%Y") as created_on
            
            ');
            $this->db->from('inventory_varients');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('inventory_varients.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_inventory_vendor_details($pdata, $getcount=null)
    {
        if(isset($pdata['search_text_1'])!="" && !empty($pdata['search_text_1']))
        {
          $this->db->where('vendors.employee_name', $pdata['search_text_1'] ); 
        }
    
          if(isset($pdata['search_on_1'])!="" && !empty($pdata['search_on_1']))
          {
              $this->db->where('vendors.status', $pdata['search_on_1'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('vendors.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('vendors.id');
            $this->db->from('vendors');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('vendors.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('vendors.*,DATE_FORMAT(vendors.created_on,"%d-%m-%Y") as created_on,
            CONCAT(company_name,'.',gst_no) as new
            ');
            $this->db->from('vendors');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('vendors.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_all_inventory_items_details($pdata, $getcount=null)
    {
        if(isset($pdata['item_name'])!="" && !empty($pdata['item_name']))
        {
          $this->db->where('inventory_items.item_name', $pdata['item_name'] ); 
        }
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('inventory_items.purchased_date >=', $pdata['from_date'] ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('inventory_items.purchased_date <=', $pdata['to_date'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('inventory_items.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('inventory_items.id');
            $this->db->from('inventory_items');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('inventory_items.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('inventory_items.*,DATE_FORMAT(inventory_items.purchased_date,"%d-%m-%Y") as purchased_date
            ');
            $this->db->from('inventory_items');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('inventory_items.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_all_cabs_details($pdata, $getcount=null)
    {
        if(isset($pdata['cab_name'])!="" && !empty($pdata['cab_name']))
        {
          $this->db->where('cabs.cab_name', $pdata['cab_name'] ); 
        }
        
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('cabs.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('cabs.id');
            $this->db->from('cabs');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('cabs.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('cabs.*,DATE_FORMAT(cabs.created_on,"%d-%m-%Y") as created_on
            ');
            $this->db->from('cabs');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('cabs.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    
    public function get_all_sent_messages_details($pdata, $getcount=null)
    {
        if(isset($pdata['message'])!="" && !empty($pdata['message']))
        {
          $this->db->like('messages.message',$pdata['message']);
        }
        $this->db->where('messages.message_type',  'normal'); 
        $this->db->where('messages.sent_from', 'school_admin' ); 
        $this->db->where('messages.from', $this->session->userdata('admin_id') ); 
       $this->db->where('messages.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('messages.id');
            $this->db->from('messages');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('messages.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('messages.*,DATE_FORMAT(messages.created_on,"%d-%m-%Y") as created_on
            ');
            $this->db->from('messages');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('messages.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_single_sent_message($id)
    {
        if($id)
        {
          $this->db->where('messages.id',$id);
        }
        $this->db->group_start();
        $this->db->where('messages.message_type',  'normal');
        $this->db->or_where('messages.message_type',  'scheduled'); 
        $this->db->group_end();
       $this->db->where('messages.school_id', $this->session->userdata('school_id') ); 
       $this->db->where('messages.sent_from', 'school_admin' );
       $this->db->where('messages.from', $this->session->userdata('admin_id') ); 
       
       
            $this->db->select('messages.*,DATE_FORMAT(messages.created_on,"%d-%m-%Y") as created_on
            ');
            $this->db->from('messages');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('messages.id','desc');
        
      
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        return $result;
    }
    
    public function get_all_scheduled_messages_details($pdata, $getcount=null)
    {

        $this->db->where('messages.message_type',  'scheduled'); 
        $this->db->where('messages.sent_from', 'school_admin' ); 
        $this->db->where('messages.from', $this->session->userdata('admin_id') ); 
       $this->db->where('messages.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('messages.id');
            $this->db->from('messages');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('messages.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('messages.*,DATE_FORMAT(messages.created_on,"%d-%m-%Y") as created_on
            ');
            $this->db->from('messages');
          //  $this->db->join('class','find_in_set(class.id, staff.employee_class)  > 0','left');
            $this->db->order_by('messages.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
     public function get_all_gate_passes_details($pdata, $getcount=null)
    {
        
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('gate_passes.picked_datetime >=', $pdata['from_date'].' 00:00:00' ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('gate_passes.picked_datetime <=', $pdata['to_date'].' 23:59:59' ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('gate_passes.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('gate_passes.id');
            $this->db->from('gate_passes');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('gate_passes.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('gate_passes.*,DATE_FORMAT(gate_passes.picked_datetime,"%d-%m-%Y %h:%i %a") as picked_datetime,students.student_name
            ');
            $this->db->from('gate_passes');
            $this->db->join('students','students.id = gate_passes.student_id','left');
            $this->db->order_by('gate_passes.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_users_by_search($searchTerm) { 
        $this->db->like('student_name', $searchTerm);
        $query = $this->db->get('students');
        return $query->result();
    }
    public function get_all_students_data_for_gatepass($student_id)
    {
        $this->db->select('students.*');
        $this->db->from('students');
        $this->db->where('students.id',$student_id);
        $qry = $this->db->get();
        return $qry->result();
    }
    
    public function get_all_visitors_details($pdata, $getcount=null)
    {
        
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('school_visitors.visiting_time >=', $pdata['from_date'].' 00:00:00' ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('school_visitors.visiting_time <=', $pdata['to_date'].' 23:59:59' ); 
          }
          if(isset($pdata['department'])!="" && !empty($pdata['department']))
          {
              $this->db->where('school_visitors.department', $pdata['department'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('school_visitors.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('school_visitors.id');
            $this->db->from('school_visitors');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('school_visitors.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('school_visitors.*,DATE_FORMAT(school_visitors.visiting_time,"%d-%m-%Y %h:%i %a") as visiting_time
            ');
            $this->db->from('school_visitors');
        //    $this->db->join('students','students.id = gate_passes.student_id','left');
            $this->db->order_by('school_visitors.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_expenses_details($pdata, $getcount=null)
    {
        
        if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('school_expenses.date_of_expense >=', $pdata['from_date'].' 00:00:00' ); 
        }
    
          if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('school_expenses.date_of_expense <=', $pdata['to_date'].' 23:59:59' ); 
          }
          if(isset($pdata['vendor'])!="" && !empty($pdata['vendor']))
          {
              $this->db->where('school_expenses.vendor', $pdata['vendor'] ); 
          }
          if(isset($pdata['category'])!="" && !empty($pdata['category']))
          {
              $this->db->where('school_expenses.expense_category', $pdata['category'] ); 
          }
          if(isset($pdata['status'])!="" && !empty($pdata['status']))
          {
              $this->db->where('school_expenses.expense_status', $pdata['status'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('school_expenses.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('school_expenses.id');
            $this->db->from('school_expenses');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('school_expenses.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('school_expenses.*,DATE_FORMAT(school_expenses.date_of_expense,"%d-%m-%Y %h:%i %a") as date_of_expense
            ');
            $this->db->from('school_expenses');
          //  $this->db->join('students','students.id = gate_passes.student_id','left');
            $this->db->order_by('school_expenses.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_all_cctv_details($pdata, $getcount=null)
    {
        
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('cctv.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('cctv.id');
            $this->db->from('cctv');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('cctv.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('cctv.* ');
            $this->db->from('cctv');
          //  $this->db->join('students','students.id = gate_passes.student_id','left');
            $this->db->order_by('cctv.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    public function get_camera_placed_option($camera_attached_type,$camera_attached_area)
    {
        if($camera_attached_type == "commonarea"){
            $this->db->select('common_area.area_name as name,common_area.id as camera_attached_area');
            $this->db->from('common_area');
            $this->db->where('common_area.id',$camera_attached_area);
            
        }else if($camera_attached_type == "class"){
            $this->db->select('CONCAT(class.class_name, '.', class.class_section) as name,class.id as camera_attached_area');
            $this->db->from('class');
            $this->db->where('class.id',$camera_attached_area);
        }
        $query = $this->db->get();
            return $query->result();
    }
    public function get_class_component_data($school_id,$class_id)
    {
        $this->db->select('class_fee_components.*,fee_components.component_name,fee_components.time_period');
        $this->db->from('class_fee_components');
        $this->db->join('fee_components','fee_components.id = class_fee_components.component_id','left');
        $this->db->where('class_fee_components.class_id',$class_id);
        $this->db->where('class_fee_components.school_id',$school_id);
        $this->db->where('class_fee_components.delete_status',1);
        $this->db->order_by('class_fee_components.id','desc');
            $query = $this->db->get();
           // echo $this->db->last_query();
            return $query->result();
    }
    public function get_fee_class_template_data($school_id,$class_id)
    {
        $this->db->select('ft.*,ftt.*,fc.component_name,fc.time_period');
        $this->db->from('school_class_fee_template_components ft');
        $this->db->join('fee_components fc','fc.id = ft.component_id','left');
        $this->db->join('school_class_fee_templates ftt','ftt.id = ft.fee_template_id and ftt.class_id = "'.$class_id.'"','inner');
        //$this->db->where('class_fee_components.class_id',$class_id);
      //  $this->db->where('class_fee_components.school_id',$school_id);
      //  $this->db->where('class_fee_components.delete_status',1);
       // $this->db->order_by('class_fee_components.id','desc');
            $query = $this->db->get();
         //   echo $this->db->last_query();
            return $query->result();
    }
    public function get_student_fee_structure_details($student_id)
    {
        
    }
    public function get_class_consession_data($school_id,$concession_id)
    {
        $this->db->select('sc.*,fc.id as component_id, fc.component_name, IFNULL(sc.concession_amount, "0") AS concession_amount');
        $this->db->from('fee_components fc');
        $this->db->join('school_concessions sc','fc.id = sc.component_id AND sc.concession_id = "'.$concession_id.'"','left');
       // $this->db->where('sc.concession_id',$concession_id);
     //   $this->db->where('sc.school_id',$school_id);
    //    $this->db->where('sc.delete_status',1);
        $this->db->order_by('sc.id','desc');
            $query = $this->db->get();
            return $query->result();
    }
    
    public function get_all_books_details($pdata, $getcount=null)
    {
         if(isset($pdata['from_date'])!="" && !empty($pdata['from_date']))
        {
          $this->db->where('school_books.added_date	 >=', $pdata['from_date'].' 00:00:00' ); 
        }
         if(isset($pdata['to_date'])!="" && !empty($pdata['to_date']))
          {
              $this->db->where('school_books.added_date	 <=', $pdata['to_date'].' 23:59:59' ); 
          }
        if(isset($pdata['status'])!="" && !empty($pdata['status']))
          {
              $this->db->where('school_books.status', $pdata['status'] ); 
          }
        if(isset($pdata['author_name'])!="" && !empty($pdata['author_name']))
          {
              $this->db->where('school_books.author_name', $pdata['author_name'] ); 
          }
          if(isset($pdata['publisher_name'])!="" && !empty($pdata['publisher_name']))
          {
              $this->db->where('school_books.publisher_name', $pdata['publisher_name'] ); 
          }
          if(isset($pdata['book_name'])!="" && !empty($pdata['book_name']))
          {
              $this->db->where('school_books.book_name', $pdata['book_name'] ); 
          }
       // $this->db->where('bookings.coupon_code !=',  ''); 
       $this->db->where('school_books.school_id', $this->session->userdata('school_id') ); 
        if($getcount)
        {
             $this->db->select('school_books.id');
            $this->db->from('school_books');
         //   $this->db->join('class','class.school_id = schools.id','left');
            $this->db->order_by('school_books.id','desc');
            $query = $this->db->get();
            return $query->num_rows();
        }
        else
        {
            $this->db->select('school_books.* ');
            $this->db->from('school_books');
          //  $this->db->join('students','students.id = gate_passes.student_id','left');
            $this->db->order_by('school_books.id','desc');
        }
        if(isset($pdata['length']))
        {
            $perpage = $pdata['length'];
            $limit = $pdata['start'];
            $generatesno=$limit+1;
            $this->db->limit($perpage,$limit);
        }
        else
        {
            $generatesno = 0;
        }
        $result = $this->db->get()->result_array();
       // echo $this->db->last_query();exit;
        foreach($result as $key=>$values)
        {
            $result[$key]['sno'] = $generatesno++;
        }
        return $result;
    }
    
    public function get_filtered_data($limit, $offset, $filters = []) {
        
        
        // Add more filters as needed
       $this->db->select('albums.id,albums.album_type,albums.title,album_content.file_name,album_content.id as video_id');
       $this->db->from('albums');
       $this->db->join('album_content','album_content.album_id = albums.id','left');
       $this->db->where('album_content.id IN (SELECT MIN(id) FROM album_content WHERE album_content.album_id = albums.id)', null, false);
       if (!empty($filters['search'])) {
            $search = $filters['search'];
           // $this->db->like('column_name', $filters['search']);
          //  $this->db->where_in('classes',$filters['search']);
             $this->db->where("FIND_IN_SET('$search',classes) !=", 0);
        }
       $this->db->limit($limit, $offset);
       $query = $this->db->get();
        //$query = $this->db->limit($limit, $offset)->get('albums');
       // echo $this->db->last_query();exit;
        return $query->result();
    }
    
    public function get_all_cab_students($id)
    {
        $this->db->select('cab_students.*,students.student_name,class.class_name,class.class_section');
        $this->db->from('cab_students');
        $this->db->join('students','students.id = cab_students.student_id','left');
        $this->db->join('class','class.id = students.class_id','left');
        $this->db->where('cab_students.cab_id',$id);
        $query = $this->db->get();
        //$query = $this->db->limit($limit, $offset)->get('albums');
       // echo $this->db->last_query();exit;
        return $query->result();
    }
    public function fetch_certificates_data($certificate_type, $student_id, $offset, $limit) {
        $this->db->select('student_certificates.*,students.student_name,students.admission_id,class.class_name,class.class_section,
        DATE_FORMAT(student_certificates.date,"%d-%m-%Y") as date');
        $this->db->from('student_certificates');
        $this->db->join('students','students.id = student_certificates.student_id','left');
        $this->db->join('class','class.id = students.class_id','left');
        if (!empty($certificate_type)) {
            $this->db->where('student_certificates.certificate_type', $certificate_type);
        }
        if (!empty($student_id)) {
            $this->db->where('student_certificates.student_id', $student_id);
        }

        $this->db->limit($limit, $offset);
       // echo $this->db->last_query();exit;
        return $this->db->get()->result();
    }
    
    public function get_fee_template_components($template_id)
    {
        $this->db->select('st.*,fc.component_name,fc.time_period');
        $this->db->from('school_class_fee_template_components st');
        $this->db->join('fee_components fc','fc.id = st.component_id','left');
        $this->db->where('st.fee_template_id',$template_id);
        $query = $this->db->get();
        //$query = $this->db->limit($limit, $offset)->get('albums');
       // echo $this->db->last_query();exit;
        return $query->result();
    }
    public function get_student_all_details($student_id)
    {
        $this->db->select('s.*,c.class_name,c.class_section');
        $this->db->from('students s');
        $this->db->join('class c','c.id = s.class_id','left');
        $this->db->where('s.id',$student_id);
        $query = $this->db->get();
        //$query = $this->db->limit($limit, $offset)->get('albums');
       // echo $this->db->last_query();exit;
        return $query->result();
    }
    public function  get_student_fee_deatils_all($student_id,$session_id)
    {
        $this->db->select('sf.*,sfc.*,fc.component_name,fc.time_period');
        $this->db->from('student_fee_structure sf');
        $this->db->join('student_fee_components sfc','sf.id = sfc.student_fee_id','left');
        $this->db->join('fee_components fc','fc.id = sfc.component_id','left');
        $this->db->where('sf.student_id',$student_id);
        $this->db->where('sf.session_id',$session_id);
        
        $query = $this->db->get();
        //$query = $this->db->limit($limit, $offset)->get('albums');
       // echo $this->db->last_query();exit;
        return $query->result();
    }
    

}//end of model