<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/userguide3/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'login';
$route['checklogin'] = 'login/checklogin';
$route['dashboard'] = 'welcome';
$route['addschool'] = 'welcome/add_school';
$route['schoolslist'] = 'welcome/schools_list';
$route['logout'] = 'welcome/is_logged_out';
$route['schooldashboard'] = 'register';


/*class*/
$route['addclass'] = 'register/add_class';
$route['editclass/(:any)'] = 'register/edit_class/$1';
$route['searchclasses'] = 'register/classes_list';
$route['transferclass'] = 'register/transfer_class_list';
$route['studentbreakup'] = 'register/student_breakup';
$route['attendance'] = 'register/school_attendance';
$route['session-listing'] = 'register/session_listing';
$route['add-session'] = 'register/add_session';



/*students*/
$route['studentslist'] = 'register/students_list';
$route['addstudent'] = 'register/student_add';
$route['editstudent/(:any)'] = 'register/edit_student/$1';

/*inquiry*/
$route['addinquiry'] = 'register/add_inquiry';
$route['editinquiry/(:any)'] = 'register/edit_inquiry/$1';
$route['searchinquiry'] = 'register/inquiry_list';
$route['add_lead/(:any)'] = 'new_lead/add_lead/$1';
$route['addnewregistration/(:any)'] = 'register/convert_inquiry_to_registration/$1';

/*registration*/
$route['addregistration'] = 'register/add_registration';
$route['searchregistration'] = 'register/registration_list';

/*fee*/
$route['feesetup'] = 'register/fee_setup';
$route['feecomponents'] = 'register/fee_components';
$route['class-fee-structure'] = 'register/class_fee_structure';
$route['add-edit-fee-template'] = 'register/add_edit_class_fee_template';
$route['concession'] = 'register/fee_concession'; 
$route['student-free-structure'] = 'register/student_fee_structure';
$route['calculate-fee'] = 'register/calculate_fee'; 

/*certificate*/
$route['certificate'] = 'register/list_certificates';
$route['preview-tc/(:any)'] = 'register/preview_tc/$1';

/*staff*/
$route['createstaff'] = 'register/create_staff';
$route['staffdetails'] = 'register/staff_list';
$route['editstaff/(:any)'] = 'register/edit_staff/$1';
$route['staff-rights/(:any)'] = 'register/staff_rights/$1';

/*inventory*/
$route['add-variants'] = 'register/add_variants';
$route['list-variants'] = 'register/list_variants';
$route['edit-variants/(:any)'] = 'register/edit_variants/$1';

$route['add-vendor'] = 'register/add_vendor';
$route['list-vendor'] = 'register/list_vendors';
$route['edit-vendor/(:any)'] = 'register/edit_vendor/$1';


$route['add-item'] = 'register/add_item';
$route['list-items'] = 'register/list_items';
$route['edit-item/(:any)'] = 'register/edit_item/$1';


/*cab*/
$route['add-cab'] = 'register/add_cab';
$route['list-cabs'] = 'register/list_cabs';
$route['edit-cab/(:any)'] = 'register/edit_cab/$1';
$route['edit-cab-route-students/(:any)'] = 'register/edit_cab_route_students/$1';


/*messages*/
$route['compose'] = 'register/compose_message';
$route['inbox'] = 'register/inbox_messages';
$route['sent'] = 'register/sent_messages';
$route['scheduled'] = 'register/scheduled_messages';
$route['view-sent-message/(:any)'] = 'register/view_sent_message/$1';

/*gate passes*/
$route['create-gatepass'] = 'register/create_gatepasses';
$route['list-gatepasses'] = 'register/list_gate_passes';

/*albums */
$route['list-albums'] = 'register/list_albums';
$route['add-album'] = 'register/add_album';
$route['edit-album/(:any)'] = 'register/edit_album/$1';

/*CCTV */

$route['create-cctv'] = 'register/add_cctv';
$route['cctv-management'] = 'register/list_cctv';
$route['edit-cctv/(:any)'] = 'register/edit_cctv/$1';
$route['add-commonarea'] = 'register/add_common_area';

/*visitos*/
$route['list-visitors'] = 'register/list_visitors';
$route['add-visitor/(:any)'] = 'new_lead/add_visitor/$1';

/*library*/
$route['list-books'] = 'register/list_books';
$route['add-book'] = 'register/add_book';
$route['edit-book/(:any)'] = 'register/edit_book/$1';

/*expenses*/
$route['list-expenses'] = 'register/list_expenses';
$route['add-expense'] = 'register/add_expense';
$route['edit-expense/(:any)'] = 'register/edit_expense/$1';


/*day care*/
$route['addmeal'] = 'register/add_meal';
$route['createactivity'] = 'register/add_activity';
$route['editactivity/(:any)'] = 'register/edit_activity/$1';
$route['daycareactivities'] = 'register/activities_list';









$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
