<main id="main" class="main">
      <div class="messagelisting py-3 px-4">
        <div class="pagetitle m-0">
          <h1>Fee Setup</h1>
          <nav>
            <ol class="breadcrumb m-0">
              <li class="breadcrumb-item"><a href="<?=base_url()?>schooldashboard">Home</a></li>
              <li class="breadcrumb-item">Fees</li>
              <li class="breadcrumb-item text-dark">Fee Setting</li>
            </ol>
          </nav>
        </div>

        <div class="dropdown">
          <button class="dropbtn">
            <span class="text-dark">Today</span> <?=date('D, d M')?>
          </button>
        </div>
      </div>

      <section class="section">
        <div class="row justify-content-center align-items-center">
          <div class="col-lg-12">
            <form class="row g-3" method="post"  id="schoolForm" enctype="multipart/form-data">
              <div class="card px-3 py-3">
                <div class="Accountdetails pt-2 px-3">
                  <div class="">
                    <h6 class="fw-bolder">Set Due Date</h6>
                  </div>
                </div>
                <div class="card-body">
                  <div class="row g-3 needs-validation" novalidate="">
                    <div class="col-md-3">
                      <label for="validationCustom02" class="form-label"
                        >Fee Cycle </label
                      >
                      <select class="form-select" required name="due_month" id="due_month">
                        <option value="">Select Fee Cycle</option>
                         <?php foreach ($months as $month): ?>
        <option value="<?php echo $month; ?>"><?php echo $month; ?></option>
    <?php endforeach; ?>
                      </select>
                    </div>

                    <div class="col-md-3">
                      <label for="validationCustom02" class="form-label"
                        >Due Date
                      </label>
                      <input type="date" class="form-control" required name="due_date" id="due_date"/>
                    </div>
                    <div class="col-md-4 pt-4">
                      <div class="form-check pt-3">
                        <input class="form-check-input" type="checkbox" value="yes" name="fee_reminders" >
                        <label class="form-check-label" for="">Enable Automatic Fee Reminders</label>
                      </div>
                    </div>

                    <div class="col-md-2 pt-3">
                      <label for="validationCustom02" class="form-label">
                        <span class="text-danger"></span
                      ></label>
                      <button class="btn btn-danger mt-4" id="createdata" type="button">
                        <i class="bi bi-check"></i> &nbsp; Save
                      </button>
                    </div>
                   
                  </div>
                </div>
              </div>

              <div class="card px-3 py-3">
                <div class="Accountdetails pt-2 px-3">
                  <div class="">
                    <h6 class="fw-bolder">Fee Settings</h6>
                  </div>
                </div>
                <div class="card-body">
                  <div class="row g-3 needs-validation" novalidate="">
                    <div class="col-md-6">
                      <label for="validationCustom02" class="form-label"
                        >Late Fee Type </label
                      >
                      <select class="form-select">
                        <option value="">Choose...</option>
                        <option value="">Fixed</option>
                        <option value="">Daily</option>
                        <option value="">Weekly</option>
                      </select>
                    </div>

                    <div class="col-md-6">
                      <label for="validationCustom02" class="form-label"
                        >Late Fee Amount
                      </label>
                      <input type="number" class="form-control" value="0"/>
                    </div>

                    <div class="col-md-6">
                      <label for="validationCustom02" class="form-label"
                        >Fee Report Emails
                      </label>
                      <textarea name="" id="" class="form-control" placeholder="please enter comma separated emails"></textarea>
                    </div>

                    <div class="col-md-6 pt-4">
                      <div class="form-check pt-3">
                        <input class="form-check-input" id="myCheck" onclick="myFunction()" type="checkbox" value=""  >
                        <label class="form-check-label" for=""> Automatic Fee Generation</label>
                      </div>
                    </div>

                    <div class="col-md-6" id="text" style="display:none" >
                      <label for="validationCustom02" class="form-label"
                        >Fee Generation Frequency</label
                      >
                      <select class="form-select">
                        <option value="">Choose...</option>
                        <option value="">Monthly</option>
                        <option value="">Quarterly</option>
                      </select>
                    </div>

                    <div class="col-md-2 pt-3">
                      <label for="validationCustom02" class="form-label">
                        <span class="text-danger"></span
                      ></label>
                      <button class="btn btn-danger mt-4">
                        <i class="bi bi-check"></i> &nbsp; Save
                      </button>
                    </div>
                   
                  </div>
                </div>
              </div>
            </form>
          </div>
          
        </div>
      </section>

      <style>
        .showdetails{
            min-height: 30vh;
            border-radius: 8px;
            overflow-y: scroll;
            box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
        }
        .actions img {
          box-shadow: rgba(0, 0, 0, 0.24) 0px 3px 8px;
          border-radius: 50%;
          width: 25px;
          padding: 5px;
        }

        small {
          font-size: 13px;
          color: #626262;
        }

        table {
          width: 100%;
          border-collapse: collapse;
          /* margin: 20px 0; */
          /* font-size: 16px; */
          text-align: left;
        }

        th,
        td {
          padding: 10px 20px;
          font-size: 14px;
        }

        th {
          background-color: #1e4284 !important;
          color: #fff !important;
        }

        .actions {
          text-align: center;
        }

        .buttons {
          padding-top: 1.5rem;
          display: flex;
          justify-content: end;
          gap: 10px;
        }

        .buttons .btn-primary,
        .btn-danger .btn-danger {
          padding: 10px;
          width: 70px !important;
        }

        select,
        option {
          font-size: 14px !important;
        }

        input[type="checkbox"] {
          accent-color: rgb(242, 4, 4);
          border: 1px solid rgb(251, 7, 7);
          width: 15px;
        }
      </style>
    </main>
    <!-- End #main -->
    
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    
     <script>
$(document).ready(function () {
    $('#createdata').on('click', function () {
        let isValid = true;
        
        //alert('hi');
        
        
        // Validate required fields
        $('#schoolForm [required]').each(function () {
            let value = $(this).val(); // Get the value
            if (Array.isArray(value)) {
                value = value.join(''); // Convert array to string
            }
            value = value ? value.toString().trim() : ''; // Convert value to string and trim

            if (value === '') {
                isValid = false;
                $(this).addClass('is-invalid'); // Add error styling
                //alert('hi');
               //showToast('Error', ${$(this).attr('placeholder')} is required, 'error');
               showToast('Error', `${$(this).attr('placeholder')} is required`, 'error');
               //showToast('Error', 'please fill required fields', 'error');
            } else {
                $(this).removeClass('is-invalid'); // Remove error styling
                $(this).addClass('is-valid'); // Mark as valid
            }
        });
        
           // Check section separately, because it's a select element
        const section = $('select[name="due_month"]');
        var usernsmam = section.val();
        if (usernsmam == '') {
            isValid = false;
            section.addClass('is-invalid'); // Add error styling for section
            showToast('Error', 'Please select Fee Cycle', 'error');
        } else {
            section.removeClass('is-invalid'); // Remove error styling
            section.addClass('is-valid'); // Mark as valid
        }
        

        if (isValid) {
            // If all fields are valid, submit the form

            const form = $('#schoolForm')[0];
            const formData = new FormData(form);

            $.ajax({
                url: '<?= base_url("register/add_fee_due_date_details"); ?>', // Your endpoint
                type: 'POST',
                data: formData,
                contentType: false,
                processData: false,
                success: function (response) {
                    const res = JSON.parse(response);
                   // alert(res.message);
                    if (res.status) {
                        showToast('Success', res.message, 'success');
                        $('#schoolForm')[0].reset(); // Reset the form
                        $('.form-control').removeClass('is-valid'); // Clear valid states
                        location.reload();
                    } else {
                        showToast('Error', res.message, 'error');
                    }
                },
                error: function () {
                    showToast('Error', 'An unexpected error occurred.', 'error');
                },
            });
        } else {
            // Scroll to the first invalid field
            $('html, body').animate({
                scrollTop: $('.is-invalid:first').offset().top - 100,
            }, 500);
        }
    });
    
     // Remove validation feedback on input
    $('#schoolForm .form-control').on('input change', function () {
        if ($(this).val().trim() !== '') {
            $(this).removeClass('is-invalid').addClass('is-valid');
        } else {
            $(this).removeClass('is-valid').addClass('is-invalid');
        }
    });
    
});

</script>